/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.commoncapabilities.api.capability.recipehandler;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.cyclops.commoncapabilities.api.capability.recipehandler.IPrototypedIngredientAlternatives;
import org.cyclops.commoncapabilities.api.capability.recipehandler.RecipeDefinition;
import org.cyclops.commoncapabilities.api.ingredient.IMixedIngredients;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.MixedIngredients;

public interface IRecipeDefinition
extends Comparable<IRecipeDefinition> {
    public Set<IngredientComponent<?, ?>> getInputComponents();

    public <T, M> List<IPrototypedIngredientAlternatives<T, M>> getInputs(IngredientComponent<T, M> var1);

    public IMixedIngredients getOutput();

    public static CompoundTag serialize(IRecipeDefinition recipe) {
        CompoundTag tag = new CompoundTag();
        CompoundTag inputTag = new CompoundTag();
        for (IngredientComponent<?, ?> component : recipe.getInputComponents()) {
            ListTag instances = new ListTag();
            for (IPrototypedIngredientAlternatives<?, ?> ingredient : recipe.getInputs(component)) {
                CompoundTag subTag = new CompoundTag();
                IPrototypedIngredientAlternatives.ISerializer<?> serializer = ingredient.getSerializer();
                subTag.m_128365_("val", serializer.serialize(component, ingredient));
                subTag.m_128344_("type", serializer.getId());
                instances.add((Object)subTag);
            }
            inputTag.m_128365_(component.getRegistryName().toString(), (Tag)instances);
        }
        tag.m_128365_("input", (Tag)inputTag);
        tag.m_128365_("output", (Tag)IMixedIngredients.serialize(recipe.getOutput()));
        return tag;
    }

    public static RecipeDefinition deserialize(CompoundTag tag) throws IllegalArgumentException {
        IdentityHashMap inputs = Maps.newIdentityHashMap();
        if (!tag.m_128441_("input")) {
            throw new IllegalArgumentException("A recipe tag did not contain a valid input tag");
        }
        if (!tag.m_128441_("output")) {
            throw new IllegalArgumentException("A recipe tag did not contain a valid output tag");
        }
        CompoundTag inputTag = tag.m_128469_("input");
        for (String componentName : inputTag.m_128431_()) {
            IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
            if (component == null) {
                throw new IllegalArgumentException("Could not find the ingredient component type " + componentName);
            }
            Tag subTag = inputTag.m_128423_(componentName);
            if (!(subTag instanceof ListTag)) {
                throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid list of instances");
            }
            ListTag instancesTag = (ListTag)subTag;
            ArrayList instances = Lists.newArrayList();
            for (Tag instanceTag : instancesTag) {
                IPrototypedIngredientAlternatives.ISerializer alternativeSerializer;
                if (instanceTag instanceof CompoundTag) {
                    CompoundTag instanceTagCompound = (CompoundTag)instanceTag;
                    byte type = instanceTagCompound.m_128445_("type");
                    alternativeSerializer = (IPrototypedIngredientAlternatives.ISerializer)IPrototypedIngredientAlternatives.SERIALIZERS.get(type);
                    if (alternativeSerializer == null) {
                        throw new IllegalArgumentException("Could not find a prototyped ingredient alternative serializer for id " + type);
                    }
                } else {
                    throw new IllegalArgumentException("The ingredient component type " + componentName + " did not contain a valid reference to instances");
                }
                Tag deserializeTag = ((CompoundTag)instanceTag).m_128423_("val");
                Object alternatives = alternativeSerializer.deserialize(component, deserializeTag);
                instances.add(alternatives);
            }
            inputs.put(component, instances);
        }
        MixedIngredients output = IMixedIngredients.deserialize(tag.m_128469_("output"));
        return new RecipeDefinition(inputs, output);
    }
}

